; Script file for Date/Time Properties
;Copyright 1999 by Henter-Joyce, Inc. 
; by DaveB
; March 2, 1999

include "HjConst.jsh"
include "HjGlobal.jsh"
include "DateTime.jsh"
include "DateTime.jsm"

globals
	int DateTimeFirst


Void Function AutoStartEvent ()
if (DateTimeFirst == 0) then
	let DateTimeFirst = 1
	Say (msg2, OT_HELP) ; "Press insert plus h for helpful keystrokes"
	Say (msg3, OT_HELP) ; "Press insert + f1 for ScreenSensitive help"
EndIf
EndFunction

Void Function SayFocusedWindow ()
var
	handle hWnd,
	int iControl
let hwnd = GetCurrentWindow ()
let iControl = GetControlID (hWnd)
If (GetWindowClass (hWnd) == wcList) then
	SayWindowTypeAndText (hWnd)
	Return
EndIf
if (iControl == iD_Cal_View) ||
GetWindowClass (hWnd) == wcCalendar then
	Say (msg1, OT_CONTROL_NAME) ; "Calendar"
	Say (GetWindowText (hWnd, true), OT_TEXT)
	Return
ElIf (iControl == ID_Month) ||
(iControl == iD_Month2) then
	Say (msg10, OT_CONTROL_NAME) ; "Month"
ElIf (iControl == iD_Year) then
	Say (msg11, OT_CONTROL_NAME) ; "Year"
ElIf (iControl == iD_Hour) then
	Say (msg12, OT_CONTROL_NAME) ; "Hour"
ElIf (iControl == iD_Second) then
	Say (msg14, OT_CONTROL_NAME); "Second"
ElIf (iControl == iD_TimeZone) then
	Say (msg17, OT_CONTROL_NAME) ; "Time zone"
Else
	If (GetWindowClass (hWnd) == "Edit") then
		Say (msg13, OT_CONTROL_NAME) ; "Minute"
		Return
	EndIf ; End of Minute label
	SayWindowTypeAndText (hWnd)
	Return
EndIf
SayWindowTypeAndText (hwnd)
EndFunction

Void Function SayHighlightedText (handle hwnd, string buffer)
var
	int iControl,
	int iControl2,
	handle hGrip
let hGrip = GetCurrentWindow ()
let iControl = GetControlID (hwnd)
let iControl2 = GetControlID (hGrip)
; to stop the repeating in various places
if (iControl2 == iD_ListBox) || ; we're focused in the list box
(iControl == ID_ListBox) ||
(iControl == ID_Hour) ||
(iControl2 == ID_Hour) ||
(iControl2 == iD_Second) ||
(iControl == iD_Second) ||
(GetWindowClass (hWnd) == "ListBox") ||
(GetWindowClass (hGrip) == "ListBox") ||
(iControl2 == iD_Second) then ; we're focused in the Seconds edit combo
	if (iControl == iControl2) then
		Return
	EndIf ; End of ID check
	Return ; Do nothing
EndIf
; For the Calendar View
If (iControl == ID_Cal_View
	|| iControl == iD_Cal_ViewNT) then
	Return
Endif
; To stop the speaking of extraneous highlighted information

if (iControl != iControl2
	&& iControl2 != iD_TimeZone) then
	Say(msgCalled, ot_message)
	Return
EndIf
Say (buffer, OT_BUFFER)
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("DateTime Properties")
EndScript

Script SayLine ()
var
	handle hWnd,
	string sClass
let hWnd = GetFocus ()
let sClass = GetWindowClass (hWnd)
If (IsPCCursor ()) then
	If (sClass == wcCalendar) then
		Say (GetWindowText (hWnd, TRUE), ot_message)
		Return
	EndIf; end of Calendar 
	if (sClass == "Edit") then
		If (GetWindowText (hWnd, true)) then
			SayWindowTypeAndText (hWnd)
			Return
		EndIf ; end of Highlight check
	EndIf ; End of Class Check 
	PerformScript SayLine()
	Return
EndIf ; End of cursor check
PerformScript SayLine()
EndScript

Script HotKeyHelp ()
Say (msg4, OT_HELP) ; "To go to the Date field, press alt plus d"
Say (msg5, OT_HELP) ; "To go to the Time Field, press alt plus t"
Say (msg3, OT_HELP) ; "Press insert + f1 for ScreenSensitive help"
EndScript

Script ScreenSensitiveHelp ()
var
	handle hWnd,
	int iControl
let hWnd = GetFocus ()
let iControl = GetControlID (hWnd)
	; for the date calendar
If (IsSameScript ()) then
	AppFileTopic ()
	Return
EndIf
if (iControl == iD_Cal_View) ||
(GetWindowClass (hwnd) == wcCalendar) then
	Say (msg6 + msg15, OT_HELP) ; "This is the Date Calendar"
	Say (msg16, OT_HELP) ; "Use the left and right arrows to increment by days, and the up and down arrows to move from week to week"
	Return
EndIf
; for Edit Combos
; msgS follow this pattern:
; This is the (control name) edit combo
; "use your editting keys to enter a value, or press the up and down arrows to change the selection"
; "Press the tab key to move to the next control"
if (iControl == iD_Month) ||
(iControl == iD_Month2) then
	If (GetWindowClass (GetCurrentWindow ()) == wcList) then
		Say (msg6 + msg19, OT_HELP)
		Say (msg20, OT_HELP)
		Say (msg9, OT_HELP)
		Return
	Else
		Say (msg6 + msg10 + msg18, OT_HELP)
		Say (msg8, OT_HELP)
		Say (msg9, OT_HELP)
		Return
	EndIf
ElIf (iControl == iD_TimeZone) then
	Say (msg6 + msg17 + msg18, OT_HELP)
	Say (msg8, OT_HELP)
	Say (msg9, OT_HELP)
	Return
EndIf
If ((IControl == iD_Minute)  
	&& GetWindowClass (hwnd) == wcList) then
	Say (msg6 + msg19, OT_HELP)
	Say (msg20, OT_HELP)
	Say (msg9, OT_HELP)
	Return
EndIf
if (GetWindowClass (hwnd) == "Edit") &&
(GetWindowSubtypeCode (hWnd) == WT_Edit) then
	If (iControl == iD_Year) then
		Say (msg6 + msg11 + msg7, OT_HELP)
		Say (msg8, OT_HELP)
		Say (msg9, OT_HELP)
	ElIf (iControl == iD_Hour) then
		Say (msg6 + msg12 + msg7, OT_HELP)
		Say (msg8, OT_HELP)
		Say (msg9, OT_HELP)
	ElIf (iControl == iD_Second) then
		Say (msg6 + msg14 + msg7, OT_HELP)
		Say (msg8, OT_HELP)
		Say (msg9, OT_HELP)
	Else ; Control ID for Minute box not returning properly 
		Say (msg6 + msg13 + msg7, OT_HELP)
		Say (msg8, OT_HELP)
		Say (msg9, OT_HELP)
	EndIf ; End of Edit Combos 
	; for the date calendar
	if (iControl == iD_Cal_View) ||
	(iControl == 711) ||
	(GetWindowClass (hwnd) == wcCalendar) then
		Say (msg6 + msg15, OT_HELP) ; "This is the Date Calendar"
	EndIf
Else
PerformScript ScreenSensitiveHelp()
EndIf ; End of Class Check 
EndScript

Script SayNextLine ()
var
	handle hWnd,
	int iControl,
	string sClass
let hWnd = GetCurrentWindow ()
let iControl = GetControlId (hWnd)
let sClass = GetWindowClass (GetCurrentWindow ());
if ((IsPcCursor ()) 
	&& (sClass == wcList) || (iControl == iD_ListBox)) then
	{DownArrow}
	Delay (3)
	Pause ()
	SayWindow (hWnd, Read_Highlighted)
ElIf ((IsPcCursor ()) 	&& (sClass == wcCalendar)) then
	NextLine ()
	Say (GetWindowText (hWnd, TRUE), ot_message)
	Return
Else
	PerformScript SayNextLine()
EndIf
EndScript

Script SayPriorLine ()
var
	handle hWnd,
	int iControl,
	string sClass
let hWnd = GetCurrentWindow ()
let iControl = GetControlId (hWnd)
let sClass = GetWindowClass (GetCurrentWindow ());
if ((IsPcCursor ()) && (sClass == wcList) || (iControl == iD_ListBox)) then
	{UpArrow}
	Delay (3)
	Pause ()
	SayWindow (hWnd, Read_Highlighted)
ElIf ((IsPcCursor ()) 	&& (sClass == wcCalendar)) then
	PriorLine ()
	Say (GetWindowText (hWnd, TRUE), ot_message)
	Return
Else
	PerformScript SayPriorLine()
EndIf
EndScript

Script SayNextWord ()
var
	handle hWnd,
	int iControl,
	string sClass
let hWnd = GetCurrentWindow ()
let iControl = GetControlId (hWnd)
let sClass = GetWindowClass (GetCurrentWindow ());
if ((IsPcCursor ()) && (sClass == wcCalendar) || (iControl == iD_Cal_View)) then
	{Control+RightArrow}
	Pause ()
	Say (GetWindowText (hWnd, TRUE), ot_message)
Else
	PerformScript SayNextWord ()
EndIf
EndScript

Script SayPriorWord ()
var
	handle hWnd,
	int iControl,
	string sClass
let hWnd = GetCurrentWindow ()
let iControl = GetControlId (hWnd)
let sClass = GetWindowClass (GetCurrentWindow ());
if ((IsPcCursor ()) && (sClass == wcCalendar) || (iControl == iD_Cal_View)) then
	{Control+LeftArrow}
	Pause ()
	Say (GetWindowText (hWnd, TRUE), ot_message)
Else
PerformScript SayPriorWord ()
EndIf
EndScript

Script SayWord ()
var
	handle hWnd,
	string sClass
let hWnd = GetFocus ()
let sClass = GetWindowClass (hWnd)
If ((IsPcCursor ()) && (sClass == wcCalendar)) then
	Say (GetWindowText (hWnd, TRUE), ot_message)
	Return
EndIf; end of Calendar 
PerformScript SayWord ()
EndScript

Script SayCharacter ()
var
	handle hWnd,
	string sClass
let hWnd = GetFocus ()
let sClass = GetWindowClass (hWnd)
If ((IsPcCursor ()) && (sClass == wcCalendar)) then
	Say (GetWindowText (hWnd, TRUE), ot_message)
	Return
EndIf; end of Calendar 
PerformScript SayCharacter ()
EndScript

Script SayWindowPromptAndText ()
var
	handle hWnd,
	string sClass
let hWnd = GetFocus ()
let sClass = GetWindowClass (hWnd)
If ((IsPcCursor ()) && (sClass == wcCalendar)) then
	Say (msg15, OT_CONTROL_NAME); "Date Calendar"
	Say (GetWindowText (hWnd, TRUE), ot_message)
	Return
EndIf; end of Calendar 
PerformScript SayWindowPromptAndText ()
EndScript

Script SayNextCharacter ()
var
	handle hWnd,
	string sClass,
	int iControl
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
let iControl = GetControlId (hWnd)
If ((IsPcCursor ()) && (sClass == wcCalendar)) then
	NextCharacter ()
	Say (GetWindowText (hWnd, TRUE), ot_message)
	Return
	; end of Calendar 
Elif ((IsPcCursor ()) 
	&& (sClass == wcList) || (iControl == iD_ListBox)) then
	NextCharacter ()
	Delay (3)
	Pause ()
	SayWindow (hWnd, Read_Highlighted)
	Return
EndIf
PerformScript SayNextCharacter ()
EndScript

Script SayPriorCharacter ()
var
	handle hWnd,
	string sClass,
	int iControl
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
let iControl = GetControlId (hWnd)
If ((IsPcCursor ()) && (sClass == wcCalendar)) then
	PriorCharacter ()
	Say (GetWindowText (hWnd, TRUE), ot_message)
	Return
	; end of Calendar 
Elif ((IsPcCursor ()) 
	&& (sClass == wcList) || (iControl == iD_ListBox)) then
	PriorCharacter ()
	Delay (3)
	Pause ()
	SayWindow (hWnd, Read_Highlighted)
	Return
EndIf
PerformScript SayPriorCharacter ()
EndScript